<?php
extract( shortcode_atts( array(
	'name' => '',
	'company' => '',
	'el_class' => '',
), $atts ) );

$css_class = array( 'sm-quote' );
$css_class = implode( ' ', $css_class );
$css_class .= sm_get_extra_class( $el_class );

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php if ( 'sm-style1' == $GLOBALS['sm-quotes-slider-style'] ): ?>
	<div class="quote-symbol"><i class="fa fa-quote-right"></i></div>
	<div class="quote-content">
		<?php echo sm_do_kses( $content ); ?>
	</div>
	<div class="quote-name">
		<span><i><?php echo esc_html( $name ); ?><?php
		if ( !empty( $company ) ) :
		?> - <?php echo esc_html( $company );
		endif; ?></i></span>
	</div>
<?php elseif ( 'sm-style2' == $GLOBALS['sm-quotes-slider-style'] ): ?>
	<div class="quote-symbol"></div>
	<div class="quote-content"><div>
		<?php echo sm_do_kses( $content ); ?>
	</div></div>
	<div class="quote-name"><?php echo esc_html( $name ); ?></div>
	<?php if ( !empty( $company ) ) : ?>
	<div class="quote-company"><?php echo esc_html( $company ); ?></div>
	<?php endif; ?>
<?php elseif ( 'sm-style3' == $GLOBALS['sm-quotes-slider-style'] ): ?>
	<div class="quote-inner-wrap">
		<div class="quote-symbol"><i class="fa fa-quote-right"></i></div>
		<div class="quote-content">
			<?php echo sm_do_kses( $content ); ?>
		</div>
		<div class="quote-name"><?php echo esc_html( $name ); ?></div>
		<?php if ( !empty( $company ) ) : ?>
		<div class="quote-company"><?php echo esc_html( $company ); ?></div>
		<?php endif; ?>
	</div>
<?php endif; ?>
</div>